#version 120


// 125 samples

/*

Settings by Sonic Ether
Bokeh Depth-of-Field by Sonic Ether
God Rays by Blizzard
Bloom shader by CosmicSpore (Modified from original source: http://myheroics.wordpress.com/2008/09/04/glsl-bloom-shader/)
Cross-Processing by Sonic Ether.
High Desaturation effect by Sonic Ether
HDR by Sonic Ether
Glare by Sonic Ether
Shaders 2.0 port of Yourself's Cell Shader, port by an anonymous user.
Bug Fixes by Kool_Kat.

*/




// Place two leading Slashes in front of the following '#define' lines in order to disable an option.
// MOTIONBLUR, HDR, and BOKEH_DOF are very beta shaders. Use at risk of weird results.
// MOTIONBLUR and BOKEH_DOF are not compatable with eachother. Shaders break when you enable both.
// GLARE is still a work in progress.
// BLOOM is currently broken.




//#define BOKEH_DOF							//Cannot be applied to water
//#define HQ_DOF								//Enable for higher quality DOF
//#define TILT_SHIFT							//Tilt shift effect. Not meant for gameplay. Google "tilt shift" for more info.
//#define TILT_SHIFT_SCALE 0.5				//Size of aperture. Higher values gives illusion of smaller world
#define GODRAYS
#define GODRAYS_EXPOSURE 0.12
#define GODRAYS_SAMPLES 6
#define GODRAYS_DECAY 0.99
#define GODRAYS_DENSITY 0.30
#define LENS							
#define LENS_POWER 0.4
//#define GLARE								//bloom
#define GLARE_AMOUNT 6.0
#define GLARE_RANGE 0.45
#define CELSHADING
#define BORDER 1.0
//#define BLOOM



//#define VINTAGE
//#define VIGNETTE
#define VIGNETTE_STRENGTH 1.30
#define CROSSPROCESS
//#define TONEMAP							
#define BRIGHTMULT 1.1          	// 1.0 = default brightness. Higher values mean brighter. 0 would be black.
#define DARKMULT 0.07				// 0.0 = normal image. Higher values will darken dark colors.
#define COLOR_BOOST	0.1				// 0.0 = normal saturation. Higher values mean more saturated image.
//#define GAMMA 0.95
#define HIGHDESATURATE
//#define MOTIONBLUR					// Cannot be applied to water
#define MOTIONBLUR_AMOUNT 1.5

//#define WATER_SHADER









uniform sampler2D gdepth;
uniform sampler2D gcolor;
uniform sampler2D composite;
uniform sampler2D gaux1; // red is our motion blur mask. If red == 1, don't blur. green is water mask
uniform sampler2D gaux2; // red is godrays

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;

uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform vec3 sunPosition;

uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;

varying vec4 texcoord;



//Land/sky mask
float land = texture2D(gaux1, texcoord.st).b;

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);


vec4 aux2 = texture2D(gaux2,texcoord.st);
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
// Standard depth function.
float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}
float edepth(vec2 coord) {
	return texture2D(gdepth, coord).x;
}
float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}
float luma(vec3 color) {
return dot(color.rgb,vec3(0.299, 0.587, 0.114));
}
float depth = texture2D(gdepth,texcoord.xy).x;
//Calculate Time of Day

	float timefract = worldTime;

	float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
	float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
	float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
	float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

	
#ifdef BOKEH_DOF

	//compare dof depth function
	float dofWeight(vec2 blur, vec2 coord) {
		float dthresh = 500.0;
		float dthresh2 = 1.0f;
		vec2 testcoord = texcoord.xy+coord;
		if (testcoord.x < 0.0 || testcoord.y < 0.0 || testcoord.x > 1.0 || testcoord.y > 1.0) return 0.0;
return (1.0f - (clamp((depth - texture2D(gdepth, texcoord.st + coord).x) * dthresh, 0.0f, 1.0f)) * (1.0f - clamp(abs(blur.x) * dthresh2, 0.0f, 1.0f)));
		//return 1.0f;	
	}

#endif

#ifdef GODRAYS

vec3 sunPos = sunPosition;



	float addGodRays(in float nc, in vec2 tx, in float noise, in float noise2, in float noise3, in float noise4, in float noise5, in float noise6, in float noise7, in float noise8, in float noise9) {
			float GDTimeMult = 0.0f;
			if (sunPos.z > 0.0f) {
				sunPos.z = -sunPos.z;
				sunPos.x = -sunPos.x;
				sunPos.y = -sunPos.y;
				GDTimeMult = TimeMidnight;	
			} else {
				GDTimeMult = TimeSunrise + TimeNoon + TimeSunset;
			}
			vec4 tpos = vec4(sunPos,1.0)*gbufferProjection;
			tpos = vec4(tpos.xyz/tpos.w,1.0);
			vec2 lightPos = tpos.xy/tpos.z;
			lightPos = (lightPos + 1.0f)/2.0f;

			//vec2 coord = tx;
			vec2 delta = (tx - lightPos) * GODRAYS_DENSITY / float(2.0);
			delta *= -sunPos.z*0.01f;
			//delta *= -sunPos.z*0.01;
			float decay = -sunPos.z / 100.0f;
				 // decay *= -sunPos.z*0.01;
			float colorGD = 0.0f;
			
			for (int i = 0; i < 2; ++i) {
			
			if (texcoord.s > 1.0f || texcoord.s < 0.0f || texcoord.t > 1.0f || texcoord.t < 0.0f) {
				break;
			}
			
				
				float sample = 0.0f;

					sample = 1.0f - texture2D(gaux2, tx + vec2(noise*delta.x, noise*delta.y)).r;
					sample += 1.0f - texture2D(gaux2, tx + vec2(noise2*delta.x, noise2*delta.y)).r;
					sample += 1.0f - texture2D(gaux2, tx + vec2(noise3*delta.x, noise3*delta.y)).r;
					sample += 1.0f - texture2D(gaux2, tx + vec2(noise4*delta.x, noise4*delta.y)).r;
					sample += 1.0f - texture2D(gaux2, tx + vec2(noise5*delta.x, noise5*delta.y)).r;
					/*
					sample += 1.0 - texture2D(gaux1, tx + vec2(noise6*delta.x, noise6*delta.y)).b;
					sample += 1.0 - texture2D(gaux1, tx + vec2(noise7*delta.x, noise7*delta.y)).b;
					sample += 1.0 - texture2D(gaux1, tx + vec2(noise8*delta.x, noise8*delta.y)).b;
					sample += 1.0 - texture2D(gaux1, tx + vec2(noise9*delta.x, noise9*delta.y)).b;
				*/
				sample *= decay;

					colorGD += sample;
					decay *= GODRAYS_DECAY;
					tx -= delta;
			}
			
			//float bubble = distance(vec2(delta.x*aspectRatio, delta.y), vec2(0.0f, 0.0f))*8.0f;
				 // bubble = clamp(bubble, 0.0f, 1.0f);
				 // bubble = 1.0f - bubble;
				  
			return (nc + GODRAYS_EXPOSURE * (colorGD))*GDTimeMult;
	}
#endif 

#ifdef CEL_SHADING
	float getCellShaderFactor(vec2 coord) {
    float d = getDepth(coord);
    vec3 n = normalize(vec3(getDepth(coord+vec2(CEL_SHADING_THICKNESS,0.0))-d,getDepth(coord+vec2(0.0,CEL_SHADING_THICKNESS))-d , CEL_SHADING_THRESHOLD));
    //clamp(n.z*3.0,0.0,1.0);
    return n.z; 
	}
#endif

#ifdef AOBLUR
float indfilter() {
	float ind;
	const float bsize = BLURRADIUS;
	vec2 edgesample = vec2(texture2D(gcolor,texcoord.st).b,0.0);
	float indsample = edgesample.x;
	int nb = 1;
	float i;
	vec2 texel = vec2(1.0f/viewWidth,1.0f/viewHeight);
	
	for ( i = 0.0; i<bsize; i+=1) {
	edgesample = texture2D(gcolor,clamp(texcoord.xy+texel*ivec2(i+1,0),texel,1.0-texel)).ba;
	if (edgesample.y > 0.55) break;
	indsample += edgesample.x;
	nb +=1;
	}
	
	for ( i = 0.0; i<bsize; i+=1) {
	edgesample = texture2D(gcolor,clamp(texcoord.xy+texel*-ivec2(i+1,0),texel,1.0-texel)).ba;
	if (edgesample.y > 0.55) break;
	indsample += edgesample.x;
	nb +=1;
	}
	
	for ( i = 0.0; i<bsize; i+=1) {
	edgesample = texture2D(gcolor,clamp(texcoord.xy+texel*ivec2(0,i+1),texel,1.0-texel)).ba;
	if (edgesample.y > 0.55) break;
	indsample += edgesample.x;
	nb +=1;
	}
	
	for ( i = 0.0; i<bsize; i+=1) {
	edgesample = texture2D(gcolor,clamp(texcoord.xy+texel*-ivec2(0,i+1),texel,1.0-texel)).ba;
	if (edgesample.y > 0.55) break;
	indsample += edgesample.x;
	nb +=1;
	}
	
	ind = indsample/float(nb);
	return ind;
}
#endif

vec4 celshade(vec4 clrr) {

//edge detect


float d = edepth(texcoord.xy);
float dtresh = 1/(far-near)/5000.0;	
 vec4 dc = vec4(d,d,d,d);
 
 vec4 sa;
 vec4 sb;
 sa.x = edepth(texcoord.xy + vec2(-pw,-ph));
 sa.y = edepth(texcoord.xy + vec2(pw,-ph));
 sa.z = edepth(texcoord.xy + vec2(-pw,0.0));
 sa.w = edepth(texcoord.xy + vec2(0.0,ph));
 
 //opposite side samples
 sb.x = edepth(texcoord.xy + vec2(pw,ph));
 sb.y = edepth(texcoord.xy + vec2(-pw,ph));
 sb.z = edepth(texcoord.xy + vec2(pw,0.0));
 sb.w = edepth(texcoord.xy + vec2(0.0,-ph));
 
 vec4 dd = abs(2.0* dc - sa - sb) - dtresh;
 dd = vec4(step(dd.x,0.0),step(dd.y,0.0),step(dd.z,0.0),step(dd.w,0.0));
 
 float e = clamp(dot(dd,vec4(0.5f,0.5f,0.5f,0.5f)),0.0,1.0);
 return vec4(clrr.rgb*e,1.0);

}

// Main --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void main() {

	vec4 color = texture2D(composite, texcoord.st);
	vec3 albedo = color.rgb;
	float iswater = texture2D(gaux1,texcoord.xy).g;
	
	
	
//Common variables

	
	vec2 Texcoord2 = texcoord.st;
	float linDepth = getDepth(depth);


const float noiseamp = 5.5f;



						const float width3 = 2.0f;
						const float height3 = 2.0f;
						float noiseX3 = ((fract(1.0f-Texcoord2.s*(width3/2.0f))*0.25f)+(fract(Texcoord2.t*(height3/2.0f))*0.75f))*2.0f-1.0f;

						
							noiseX3 = clamp(fract(sin(dot(Texcoord2 ,vec2(18.9898f,28.633f))) * 4378.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX3 *= (0.10f*noiseamp);

						const float width2 = 1.0f;
						const float height2 = 1.0f;
						float noiseX2 = ((fract(1.0f-Texcoord2.s*(width2/2.0f))*0.25f)+(fract(Texcoord2.t*(height2/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY2 = ((fract(1.0f-Texcoord2.s*(width2/2.0f))*0.75f)+(fract(Texcoord2.t*(height2/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX2 = clamp(fract(sin(dot(Texcoord2 ,vec2(12.9898f,78.233f))) * 43758.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY2 = clamp(fract(sin(dot(Texcoord2 ,vec2(12.9898f,78.233f)*2.0f)) * 43758.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX2 *= (0.10f*noiseamp);
						noiseY2 *= (0.10f*noiseamp);
						

						const float width4 = 3.0f;
						const float height4 = 3.0f;
						float noiseX4 = ((fract(1.0f-Texcoord2.s*(width4/2.0f))*0.25f)+(fract(Texcoord2.t*(height4/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY4 = ((fract(1.0f-Texcoord2.s*(width4/2.0f))*0.75f)+(fract(Texcoord2.t*(height4/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX4 = clamp(fract(sin(dot(Texcoord2 ,vec2(16.9898f,38.633f))) * 41178.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY4 = clamp(fract(sin(dot(Texcoord2 ,vec2(21.9898f,66.233f)*2.0f)) * 9758.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX4 *= (0.10f*noiseamp);
						noiseY4 *= (0.10f*noiseamp);	

						const float width5 = 4.0f;
						const float height5 = 4.0f;
						float noiseX5 = ((fract(1.0f-Texcoord2.s*(width5/2.0f))*0.25f)+(fract(Texcoord2.t*(height5/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY5 = ((fract(1.0f-Texcoord2.s*(width5/2.0f))*0.75f)+(fract(Texcoord2.t*(height5/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX5 = clamp(fract(sin(dot(Texcoord2 ,vec2(11.9898f,68.633f))) * 21178.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY5 = clamp(fract(sin(dot(Texcoord2 ,vec2(26.9898f,71.233f)*2.0f)) * 6958.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX5 *= (0.10f*noiseamp);
						noiseY5 *= (0.10f*noiseamp);							
						
						const float width6 = 4.0f;
						const float height6 = 4.0f;
						float noiseX6 = ((fract(1.0f-Texcoord2.s*(width6/2.0f))*0.25f)+(fract(Texcoord2.t*(height6/2.0f))*0.75f))*2.0f-1.0f;
						float noiseY6 = ((fract(1.0f-Texcoord2.s*(width6/2.0f))*0.75f)+(fract(Texcoord2.t*(height6/2.0f))*0.25f))*2.0f-1.0f;

						
							noiseX6 = clamp(fract(sin(dot(Texcoord2 ,vec2(21.9898f,78.633f))) * 29178.5453f),0.0f,1.0f)*2.0f-1.0f;
							noiseY6 = clamp(fract(sin(dot(Texcoord2 ,vec2(36.9898f,81.233f)*2.0f)) * 16958.5453f),0.0f,1.0f)*2.0f-1.0f;
						
						noiseX6 *= (0.10f*noiseamp);
						noiseY6 *= (0.10f*noiseamp);						
					
						float width7 = 6.0;
						float height7 = 6.0;
						float noiseX7 = ((fract(1.0-Texcoord2.s*(width7/2.0))*0.25)+(fract(Texcoord2.t*(height7/2.0))*0.75))*2.0-1.0;
						float noiseY7 = ((fract(1.0-Texcoord2.s*(width7/2.0))*0.75)+(fract(Texcoord2.t*(height7/2.0))*0.25))*2.0-1.0;

						
							noiseX7 = clamp(fract(sin(dot(Texcoord2 ,vec2(12.9898,44.633))) * 51178.5453),0.0,1.0)*2.0-1.0;
							noiseY7 = clamp(fract(sin(dot(Texcoord2 ,vec2(43.9898,61.233)*2.0)) * 9958.5453),0.0,1.0)*2.0-1.0;
						
						noiseX7 *= (0.10f*noiseamp);
						noiseY7 *= (0.10f*noiseamp);
						
						float width8 = 7.0;
						float height8 = 7.0;
						float noiseX8 = ((fract(1.0-Texcoord2.s*(width8/2.0))*0.25)+(fract(Texcoord2.t*(height8/2.0))*0.75))*2.0-1.0;
						float noiseY8 = ((fract(1.0-Texcoord2.s*(width8/2.0))*0.75)+(fract(Texcoord2.t*(height8/2.0))*0.25))*2.0-1.0;

						
							noiseX8 = clamp(fract(sin(dot(Texcoord2 ,vec2(14.9898,47.633))) * 51468.5453),0.0,1.0)*2.0-1.0;
							noiseY8 = clamp(fract(sin(dot(Texcoord2 ,vec2(13.9898,81.233)*2.0)) * 6388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX8 *= (0.10f*noiseamp);
						noiseY8 *= (0.10f*noiseamp);
						
						float width9 = 8.0;
						float height9 = 8.0;
						float noiseX9 = ((fract(1.0-Texcoord2.s*(width9/2.0))*0.25)+(fract(Texcoord2.t*(height9/2.0))*0.75))*2.0-1.0;
						float noiseY9 = ((fract(1.0-Texcoord2.s*(width9/2.0))*0.75)+(fract(Texcoord2.t*(height9/2.0))*0.25))*2.0-1.0;

						
							noiseX9 = clamp(fract(sin(dot(Texcoord2 ,vec2(24.9898,59.633))) * 55468.5453),0.0,1.0)*2.0-1.0;
							noiseY9 = clamp(fract(sin(dot(Texcoord2 ,vec2(23.9898,95.233)*2.0)) * 16388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX9 *= (0.10f*noiseamp);
						noiseY9 *= (0.10f*noiseamp);
						
						float width10 = 9.0;
						float height10 = 9.0;
						float noiseX10 = ((fract(1.0-Texcoord2.s*(width10/2.0))*0.25)+(fract(Texcoord2.t*(height10/2.0))*0.75))*2.0-1.0;
						float noiseY10 = ((fract(1.0-Texcoord2.s*(width10/2.0))*0.75)+(fract(Texcoord2.t*(height10/2.0))*0.25))*2.0-1.0;

						
							noiseX10 = clamp(fract(sin(dot(Texcoord2 ,vec2(26.9898,59.633))) * 57468.5453),0.0,1.0)*2.0-1.0;
							noiseY10 = clamp(fract(sin(dot(Texcoord2 ,vec2(25.9898,95.233)*2.0)) * 18388.5453),0.0,1.0)*2.0-1.0;
						
						noiseX10 *= (0.10f*noiseamp);
						noiseY10 *= (0.10f*noiseamp);
					


/////////////////////////////////////////////////////WATER//////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////WATER//////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////WATER//////////////////////////////////////////////////////////////////////////
#ifdef WATER_SHADER
	if (iswater > 0.9) {
	const float rspread = 0.30f;						//How long reflections are spread across the screen
	
	float rdepth = depth;


float pix_x = 1.0f / viewWidth;
float pix_y = 1.0f / viewHeight;

	rdepth = pow(rdepth, 1.0f);

const float wnormalclamp = 0.05f;
	
//Detect water surface normals

	//Compare change in depth texture over 1 pixel and return an angle
		float wnormal_x1 = texture2D(gdepth, texcoord.st + vec2(pix_x, 0.0f)).x - texture2D(gdepth, texcoord.st).x;
		float wnormal_x2 = texture2D(gdepth, texcoord.st).x - texture2D(gdepth, texcoord.st + vec2(-pix_x, 0.0f)).x;			
		float wnormal_x = 0.0f;
		
		if(abs(wnormal_x1) > abs(wnormal_x2)){
			wnormal_x = wnormal_x2;
		} else {
			wnormal_x = wnormal_x1;
		}
		wnormal_x /= 1.0f - rdepth;	

		wnormal_x = clamp(wnormal_x, -wnormalclamp, wnormalclamp);
		
		wnormal_x *= rspread*1.0f;
		

			  
			  
		float wnormal_y1 = texture2D(gdepth, texcoord.st + vec2(0.0f, pix_y)).x - texture2D(gdepth, texcoord.st).x;
		float wnormal_y2 = texture2D(gdepth, texcoord.st).x - texture2D(gdepth, texcoord.st + vec2(0.0f, -pix_y)).x;		
		float wnormal_y;
		
		if(abs(wnormal_y1) > abs(wnormal_y2)){
			wnormal_y = wnormal_y2;
		} else {
			wnormal_y = wnormal_y1;
		}	
		wnormal_y /= 1.0f - rdepth;			

		wnormal_y = clamp(wnormal_y, -wnormalclamp, wnormalclamp);
		
		wnormal_y *= rspread*1.0f*aspectRatio;
		
		  		  
		  
		 
		  
//REFRACTION

	//Heightmap of small waves
	float waves = texture2D(gaux2, texcoord.st).g;
	float wavesraw = waves;
		  waves -= 0.5f;
		  waves *= 1.0 - depth;
		  waves *= 100.0f;

	//Detect angle of waves by comparing 1 pixel difference and resolving discontinuities
	float wavesdeltax1 = texture2D(gaux2, texcoord.st).g - texture2D(gaux2, texcoord.st + vec2(-pix_x, 0.0f)).g;
	float wavesdeltax2 = texture2D(gaux2, texcoord.st + vec2(pix_x, 0.0f)).g - texture2D(gaux2, texcoord.st).g;
	float wavesdeltax;
	
		if(abs(wavesdeltax1) > abs(wavesdeltax2)){
			wavesdeltax = wavesdeltax2;
		} else {
			wavesdeltax = wavesdeltax1;
		}
		
		wavesdeltax = clamp(wavesdeltax, -0.1f, 0.1f);
		
		wavesdeltax *= 1.0f - depth;
		wavesdeltax *= 30.0f;
		  
		  
	float wavesdeltay1 = texture2D(gaux2, texcoord.st).g - texture2D(gaux2, texcoord.st + vec2(0.0f, -pix_y)).g;
	float wavesdeltay2 = texture2D(gaux2, texcoord.st + vec2(0.0f, pix_y)).g - texture2D(gaux2, texcoord.st).g;
	float wavesdeltay = 0.0f;
	
		if(abs(wavesdeltay1) > abs(wavesdeltay2)){
			wavesdeltay = wavesdeltay2;
		} else {
			wavesdeltay = wavesdeltay1;
		}
		wavesdeltay *= 1.0f - depth;
		wavesdeltay *= 30.0f;
		
		wavesdeltay = clamp(wavesdeltay, -0.1f, 0.1f);
		  


	


float refractamount = 500.1154f*0.75f;
float refractamount2 = 0.0214f*0.00f;
float refractamount3 = 0.214f*0.05f;

	vec3 refracted = vec3(0.0f);
	float refractedmask_r = 0.0f;
	float refractedmask_g = 0.0f;
	float refractedmask_b = 0.0f;
	
	for (int i = 0; i < 1; ++i) {
	
			vec2 refractcoord_r = texcoord.st * (1.0f + waves*refractamount3) - (waves*refractamount3/2.0f) + vec2(wavesdeltax*refractamount*(-wnormal_x*0.3f) + waves*refractamount2 + (-wnormal_x*0.4f), wavesdeltay*refractamount*(-wnormal_y*0.3f) + waves*refractamount2 + (-wnormal_y*0.4f)) * 1.6f ;
			vec2 refractcoord_g = texcoord.st * (1.0f + waves*refractamount3) - (waves*refractamount3/2.0f) + vec2(wavesdeltax*refractamount*(-wnormal_x*0.3f) + waves*refractamount2 + (-wnormal_x*0.4f), wavesdeltay*refractamount*(-wnormal_y*0.3f) + waves*refractamount2 + (-wnormal_y*0.4f)) * 1.3f;
			vec2 refractcoord_b = texcoord.st * (1.0f + waves*refractamount3) - (waves*refractamount3/2.0f) + vec2(wavesdeltax*refractamount*(-wnormal_x*0.3f) + waves*refractamount2 + (-wnormal_x*0.4f), wavesdeltay*refractamount*(-wnormal_y*0.3f) + waves*refractamount2 + (-wnormal_y*0.4f));

			
			refractcoord_r.s = clamp(refractcoord_r.s, 0.001f, 0.999f);
			refractcoord_r.t = clamp(refractcoord_r.t, 0.001f, 0.999f);	
			
			refractcoord_g.s = clamp(refractcoord_g.s, 0.001f, 0.999f);
			refractcoord_g.t = clamp(refractcoord_g.t, 0.001f, 0.999f);
			
			refractcoord_b.s = clamp(refractcoord_b.s, 0.001f, 0.999f);
			refractcoord_b.t = clamp(refractcoord_b.t, 0.001f, 0.999f);
			
			if (refractcoord_r.st * vec2(iswater) == 0.0f) {
				break;
			}			
			
			if (refractcoord_g.st * vec2(iswater) == 0.0f) {
				break;
			}			
			
			if (refractcoord_b.st * vec2(iswater) == 0.0f) {
				break;
			}
			
			refracted.r = texture2D(composite, refractcoord_r).r;
			refracted.g = texture2D(composite, refractcoord_g).g;
			refracted.b = texture2D(composite, refractcoord_b).b;
			
			
			refractedmask_r = texture2D(gaux1, refractcoord_r).g;
			refractedmask_g = texture2D(gaux1, refractcoord_g).g;
			refractedmask_b = texture2D(gaux1, refractcoord_b).g;
			
	
			}
			
	color.r = mix(color.r, refracted.r, refractedmask_r);
	color.g = mix(color.g, refracted.g, refractedmask_g);
	color.b = mix(color.b, refracted.b, refractedmask_b);



//REFLECTION


	//color.rgb = worldposition.g;
	
	vec3 reflection = vec3(0.0f);
	float rtransy = 0.01f * rspread;
	float rtransin = 0.05f;
	
	const float rstrong = 1.2f;
	const float reflectwaviness = 0.00195f;
	const float rcurve = 1.0f;
	
	//coordinates for translating reflection
	vec2 coordnormal = texcoord.st;
	vec2 coordin = texcoord.st;
	vec2 rcoord = vec2(0.0f);
	
	float dwaves = waves * 0.4f * reflectwaviness;
	float dwavesdeltax = wavesdeltax * 3.3f * reflectwaviness;
	float dwavesdeltay = wavesdeltay * 3.3f * reflectwaviness;
	float reflectmask = 0.0f;
	float reflectmaskhold = 0.0f;
	float rnoise = 5.0f;
	/*
	float depthcheck = 0.0f;
	float depthcheck2 = 0.0f;
	float depthpass = 0.0f;
	
	int samples = 1;
	
	
			float redge = distance(texcoord.s, 0.5f);
			  redge = max(redge, distance(texcoord.t, 0.5f));
			  redge *= 2.0f;
			  redge = clamp(redge * 4.0f - 3.0f, 0.0f, 1.0f);
			  redge = 1.0f;
	
			
			for (int i = 0; i < 6; ++i) {

	
	
				coordin = coordin * (1.0f + rtransin) - (rtransin/2.0f);
				coordin = coordin + vec2(dwavesdeltax, dwavesdeltay);
				coordnormal = clamp(coordnormal + vec2(0.0, rtransy*0.0f)*redge, 0.001f, 0.999f);
								
				//rcoord = mix(coordin, coordnormal, 1.0);
				coordnormal = clamp(coordnormal + vec2(dwavesdeltax*4.0f + wnormal_x, dwavesdeltay*4.0f + wnormal_y)*(samples * samples - 1)*redge, 0.001f, 0.999f);
				
				rcoord = mix(coordnormal, coordnormal, down);
				

				
				depthcheck = (depth - texture2D(gdepth, clamp(rcoord, 0.001f, 0.999f)).x);
				depthcheck = 1.0f - depthcheck;
				depthcheck = clamp(depthcheck * 40.0 - 39.0f, 0.0f, 1.0f);
				depthcheck2 = clamp(depthcheck * 70.0 - 69.0f, 0.0f, 1.0f);
				
				//	if (depthcheck < 0.0f) {
				//		depthpass = 0.0f;
				//	} else {
				//		depthpass = 1.0f;
				//	}
				
			//depthcheck = 1.0f;
							if (rcoord.st * vec2(iswater) == 0.0f) {
					break;
				}
				
				reflectmask  = ((1.0 - texture2D(gaux1, clamp(  (rcoord*depthcheck + vec2(noiseX2*wnormal_x*rnoise*(samples - 1), noiseX2*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).g) * ((7.0f - samples)/7.0f))/4.0;
				reflectmask += ((1.0 - texture2D(gaux1, clamp(  (rcoord*depthcheck + vec2(noiseY2*wnormal_x*rnoise*(samples - 1), noiseY2*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).g) * ((7.0f - samples)/7.0f))/4.0;
				reflectmask += ((1.0 - texture2D(gaux1, clamp(  (rcoord*depthcheck + vec2(noiseX4*wnormal_x*rnoise*(samples - 1), noiseX4*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).g) * ((7.0f - samples)/7.0f))/4.0;
				reflectmask += ((1.0 - texture2D(gaux1, clamp(  (rcoord*depthcheck + vec2(noiseY4*wnormal_x*rnoise*(samples - 1), noiseY4*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).g) * ((7.0f - samples)/7.0f))/4.0;
				reflectmask += ((1.0 - texture2D(gaux1, clamp(  (rcoord*depthcheck + vec2(noiseX5*wnormal_x*rnoise*(samples - 1), noiseX5*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).g) * ((7.0f - samples)/7.0f))/4.0;
				reflectmask += ((1.0 - texture2D(gaux1, clamp(  (rcoord*depthcheck + vec2(noiseY5*wnormal_x*rnoise*(samples - 1), noiseY5*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).g) * ((7.0f - samples)/7.0f))/4.0;
				reflectmask += ((1.0 - texture2D(gaux1, clamp(  (rcoord*depthcheck + vec2(noiseX6*wnormal_x*rnoise*(samples - 1), noiseX6*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).g) * ((7.0f - samples)/7.0f))/4.0;
				reflectmask += ((1.0 - texture2D(gaux1, clamp(  (rcoord*depthcheck + vec2(noiseY6*wnormal_x*rnoise*(samples - 1), noiseY6*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).g) * ((7.0f - samples)/7.0f))/4.0;
																																								
				//reflectmask *= depthcheck2;					
																																								
				reflection  += 	((texture2D(composite, clamp(   (rcoord*depthcheck + vec2(noiseX2*wnormal_x*rnoise*(samples - 1), noiseX2*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).rgb * reflectmask) * ((7.0f - samples)/7.0f))/4.0;
				reflection  += 	((texture2D(composite, clamp(   (rcoord*depthcheck + vec2(noiseY2*wnormal_x*rnoise*(samples - 1), noiseY2*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).rgb * reflectmask) * ((7.0f - samples)/7.0f))/4.0;
				reflection  += 	((texture2D(composite, clamp(   (rcoord*depthcheck + vec2(noiseX4*wnormal_x*rnoise*(samples - 1), noiseX4*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).rgb * reflectmask) * ((7.0f - samples)/7.0f))/4.0;
				reflection  += 	((texture2D(composite, clamp(   (rcoord*depthcheck + vec2(noiseY4*wnormal_x*rnoise*(samples - 1), noiseY4*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).rgb * reflectmask) * ((7.0f - samples)/7.0f))/4.0;
				reflection  += 	((texture2D(composite, clamp(   (rcoord*depthcheck + vec2(noiseX5*wnormal_x*rnoise*(samples - 1), noiseX5*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).rgb * reflectmask) * ((7.0f - samples)/7.0f))/4.0;
				reflection  += 	((texture2D(composite, clamp(   (rcoord*depthcheck + vec2(noiseY5*wnormal_x*rnoise*(samples - 1), noiseY5*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).rgb * reflectmask) * ((7.0f - samples)/7.0f))/4.0;
				reflection  += 	((texture2D(composite, clamp(   (rcoord*depthcheck + vec2(noiseX6*wnormal_x*rnoise*(samples - 1), noiseX6*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).rgb * reflectmask) * ((7.0f - samples)/7.0f))/4.0;
				reflection  += 	((texture2D(composite, clamp(   (rcoord*depthcheck + vec2(noiseY6*wnormal_x*rnoise*(samples - 1), noiseY6*wnormal_y*rnoise*(samples - 1))*redge*depthcheck), 0.001f, 0.999f)).rgb * reflectmask) * ((7.0f - samples)/7.0f))/4.0;
				
				//reflection *= depthcheck;
	
				reflectmaskhold += reflectmask;
			
				rtransy += 0.01f * rspread;
				rtransin += 0.01f * rspread;

				samples += 1;
				
			if (rcoord.st * vec2(iswater) == 0.0f) {
					break;
				}
			
			}
			
			reflection /= samples - 1;
			reflectmaskhold /= samples - 1;
			
			reflectmaskhold = pow(reflectmaskhold, 0.8f)*1.5f;
			
						*/
			//Darken objects behind water
			color.rgb = mix(color.rgb, vec3(color.r * 0.3f, color.g * 0.4f, color.b * 0.5f) * (1.0 - reflectmaskhold), iswater);
			//color.rgb = mix(color.rgb, vec3(color.r * 0.05f, color.g * 0.05f, color.b * 0.05f) * (1.0 - reflectmaskhold), iswater);
			
			//Add reflections to water only >:3
			//reflection *= iswater;
			
			//color.rgb = color.rgb + (reflection * rstrong);
			
			float fakecaustic = abs(dwavesdeltax) + abs(dwavesdeltay);
			      fakecaustic *= 1000.0f;
				  fakecaustic = pow(fakecaustic, 2.0f);
				  fakecaustic *= iswater;
				  
			color.rgb *= 1.0f + fakecaustic;
			
			
			

//faker reflections

		//color.rgb = mix(color.rgb, vec3(color.r * 0.25f, color.g * 0.35f, color.b * 0.35f), iswater);

			
}
#endif

#ifdef CELSHADING
if (land > 0.9 && iswater < 0.9) color = celshade(color);
 
#endif

#ifdef GODRAYS

	float GR = addGodRays(0.0f, Texcoord2, noiseX3, noiseX4, noiseY4, noiseX2, noiseY2, noiseX5, noiseY5, noiseX6, noiseY6)/2.0;

	float GRr = 1.0 - aux2.r;
	
	//GR = mix(GR, 0.0f, rainx);
	
	/*
	float GRs  = 1.0 - texture2D(gaux1, vec2(0.55, 0.55)).g;
		  GRs += 1.0 - texture2D(gaux1, vec2(0.55, 0.45)).g;
		  GRs += 1.0 - texture2D(gaux1, vec2(0.45, 0.55)).g;
		  GRs += 1.0 - texture2D(gaux1, vec2(0.45, 0.45)).g;

		  GRs /= 3.0;
	*/
	
	vec3 sunrise_sun;
	 sunrise_sun.r = 1.0 * TimeSunrise;
	 sunrise_sun.g = 0.629 * TimeSunrise;
	 sunrise_sun.b = 0.416 * TimeSunrise;
	
	vec3 noon_sun;
	 noon_sun.r = 1.0 * TimeNoon;
	 noon_sun.g = 1.0 * TimeNoon;
	 noon_sun.b = 0.98 * TimeNoon;
	
	vec3 sunset_sun;
	 sunset_sun.r = 0.99 * TimeSunset;
	 sunset_sun.g = 0.839 * TimeSunset;
	 sunset_sun.b = 0.666 * TimeSunset;
	
	vec3 midnight_sun;
	 midnight_sun.r = 0.45 * TimeMidnight * 0.20f;
	 midnight_sun.g = 0.70 * TimeMidnight * 0.20f;
	 midnight_sun.b = 1.00 * TimeMidnight * 0.20f;
	 
	vec3 rain_sun_day;
	 rain_sun_day.r = 1.0f * (1.0f - TimeMidnight) * 0.1f; 
	 rain_sun_day.g = 1.0f * (1.0f - TimeMidnight) * 0.1f;
	 rain_sun_day.b = 1.0f * (1.0f - TimeMidnight) * 0.1f;	
	 
	vec3 rain_sun_night;
	 rain_sun_night.r = 1.0f * (TimeMidnight) * 0.0f;
	 rain_sun_night.g = 1.0f * (TimeMidnight) * 0.0f;
	 rain_sun_night.b = 1.0f * (TimeMidnight) * 0.0f;
	
	vec3 sunlight;
	 sunlight = mix(sunrise_sun + noon_sun + sunset_sun + midnight_sun, rain_sun_day + rain_sun_night, rainx);

	
	

	
	
	GR = pow(GR, 1.0f)*2.5f;
	
	color.r += pow(GR*sunlight.r, 1.0f);
	color.g += pow(GR*sunlight.g, 1.0f);
	color.b += pow(GR*sunlight.b, 1.0f);
	
	
	/*
	//Adjust brightness of entire screen based on what the center value of GRs is
	color.r = color.r * (1.0 - (GRs * 0.3));
	color.g = color.g * (1.0 - (GRs * 0.35));
	color.b = color.b * (1.0 - (GRs * 0.5));
	
	color.r = clamp(color.r, 0.0, 1.0);
	color.g = clamp(color.g, 0.0, 1.0);
	color.b = clamp(color.b, 0.0, 1.0);
	
	*/
	
#endif



#ifdef GLARE
	float glaresub = luma(color.rgb);
if (glaresub < 0.5 && iswater < 0.5) {				//excluding bright pixels for optimisation and water because of bugs
	
	float radius = 0.002f*GLARE_RANGE;
	const float radiusv = 0.002f;
	const float bloomintensity = 0.1f*GLARE_AMOUNT;
	
	const float glarex = 2.0f;
	float sweight;
	float bloomnoise = 0.0;
	float bloomnoisey = 0.0;
	

	vec4 clr = vec4(0.0f);
	vec4 add;
	//clr += texture2D(composite, texcoord.st);
	
	//horizontal (70 taps)

	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(5.0f+bloomnoise,5.0+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(4.0f+bloomnoise,4.0+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*2.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(3.0f+bloomnoise,3.0+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*3.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(2.0f+bloomnoise,2.0+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*4.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(1.0f+bloomnoise,1.0+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*5.0;
		
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(-1.0f+bloomnoise,1.0+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*5.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(-2.0f+bloomnoise,2.0+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*4.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(-3.0f+bloomnoise,3.0+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*3.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(-4.0f+bloomnoise,4.0+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*2.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(-5.0f+bloomnoise,5.0+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight;
	//vertical

	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(5.0+bloomnoise,-5.0f+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(4.0+bloomnoise,-4.0f+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*2.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(3.0+bloomnoise,-3.0f+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*3.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(2.0+bloomnoise,-2.0f+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*4.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(1.0+bloomnoise,-1.0f+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*5.0;
	
	
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(-5.0+bloomnoise,-5.0f+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(-4.0+bloomnoise,-4.0f+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*2.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(-3.0+bloomnoise,-3.0f+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*3.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(-2.0+bloomnoise,-2.0f+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*4.0;
	add =  max(texture2D(composite, clamp(texcoord.st + (vec2(-1.0+bloomnoise,-1.0f+bloomnoisey))*radius,ph,1.0-ph)),0.0f);
	sweight = max(luma(add.rgb)-glaresub,0.0);
	clr += add*sweight*sweight*sweight*5.0;
	
	clr = clr/20.0;
	


	
	color.r = color.r + clr.r*bloomintensity;
	color.g = color.g + clr.g*bloomintensity;
	color.b = color.b + clr.b*bloomintensity;
	color = max(color, 0.0f);
	
}
#endif







#ifdef VIGNETTE

float dv = distance(texcoord.st, vec2(0.5f, 0.5f));

dv *= VIGNETTE_STRENGTH;

dv = 1.0f - dv;

dv = pow(dv, 0.2f);

dv *= 1.9f;
dv -= 0.9f;

color.rgb *= dv;

#endif






#ifdef LENS

vec3 sP = sunPosition;
			float texratio = texcoord.s*aspectRatio;
			vec4 tpos = vec4(sP,1.0)*gbufferProjection;
			tpos = vec4(tpos.xyz/tpos.w,1.0);
			vec2 lPos = tpos.xy / tpos.z;
			lPos = (lPos + 1.0f)/2.0f;
			vec2 checkcoord = lPos;
			if (checkcoord.x < 1.0f && checkcoord.x > 0.0f && checkcoord.y < 1.0f && checkcoord.y > 0.0f && TimeMidnight < 1.0) {
			
			float sunmask = 0.0f;
			float sunstep = -4.5f;
			float masksize = 0.004f;
					


							sunmask = 1.0f - texture2D(gaux1, lPos).b;
	

					sunmask *= LENS_POWER * (1.0f - TimeMidnight);
					sunmask *= 1.0 - rainx;
			if (sunmask > 0.02) {
						//Detect if sun is on edge of screen
				float edgemaskx = clamp(distance(lPos.x, 0.5f)*8.0f - 3.0f, 0.0f, 1.0f);
				float edgemasky = clamp(distance(lPos.y, 0.5f)*8.0f - 3.0f, 0.0f, 1.0f);
			
						
						
			////Darken colors if the sun is visible
				float centermask = 1.0 - clamp(distance(lPos.xy, vec2(0.5f, 0.5f))*2.0, 0.0, 1.0);
						centermask = pow(centermask, 1.0f);
						centermask *= sunmask;
			
				color.r *= (1.0 - centermask * (1.0f - TimeMidnight));
				color.g *= (1.0 - centermask * (1.0f - TimeMidnight));
				color.b *= (1.0 - centermask * (1.0f - TimeMidnight));
			
			
			//Adjust global flare settings
				const float flaremultR = 0.8f;
				const float flaremultG = 1.0f;
				const float flaremultB = 1.5f;
			
				float flarescale = 1.0f;
				const float flarescaleconst = 1.0f;
			
			
			//Flare gets SMALLER at center of screen asdf
			flarescale *= (1.0 - centermask);
				//flarescale *= centermask*5.5;//flarescale *= (1.0 - centermask);
			  //flarescale = clamp(flarescale, 0.4, 10.0);
				//flarescale = flarescale*0.4;
					  
										
					
			//Far blue flare MAIN
			  vec2 flare3scale = vec2(5.0f*flarescale, 5.0f*flarescale);
			  float flare3pow = 0.07f;
			  float flare3fill = 10.0f;
			  float flare3offset = -0.5f;
			vec2 flare3pos = vec2(  ((1.0 - lPos.x)*(flare3offset + 1.0) - (flare3offset*0.5))  *aspectRatio*flare3scale.x,  ((1.0 - lPos.y)*(flare3offset + 1.0) - (flare3offset*0.5))  *flare3scale.y);
			
			
			float flare3 = distance(flare3pos, vec2(texcoord.s*aspectRatio*flare3scale.x, texcoord.t*flare3scale.y));
				  flare3 = 0.5 - flare3;
				  flare3 = clamp(flare3*flare3fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3 = sin(flare3*1.57075);
				  flare3 *= sunmask;
				  flare3 = pow(flare3, 1.1f);
				  
				  flare3 *= flare3pow;			
				  
				  
				 				  
				  
				  	color.r += flare3*1.0f*flaremultR;
					color.g += flare3*0.7f*flaremultG;
					color.b += flare3*0.6f*flaremultB;

					
				//Far blue flare 2
			  vec2 flare3GTAscale = vec2(10.0f*flarescale, 10.0f*flarescale);
			  float flare3GTApow = 0.5f;
			  float flare3GTAfill = 10.0f;
			  float flare3GTAoffset = -0.9f; //-0.5
			vec2 flare3GTApos = vec2(  ((1.0 - lPos.x)*(flare3GTAoffset + 1.0) - (flare3GTAoffset*0.5))  *aspectRatio*flare3GTAscale.x,  ((1.0 - lPos.y)*(flare3GTAoffset + 1.0) - (flare3GTAoffset*0.5))  *flare3GTAscale.y);
			
			
			float flare3GTA = distance(flare3GTApos, vec2(texcoord.s*aspectRatio*flare3GTAscale.x, texcoord.t*flare3GTAscale.y));
				  flare3GTA = 0.5 - flare3GTA;
				  flare3GTA = clamp(flare3GTA*flare3GTAfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3GTA = sin(flare3GTA*1.57075);
				  flare3GTA *= sunmask;
				  flare3GTA = pow(flare3GTA, 1.1f);
				  
				  flare3GTA *= flare3GTApow;			
				  
				  
				 				  
				  
				  	color.r += flare3GTA*0.0f*flaremultR;
					color.g += flare3GTA*0.3f*flaremultG;
					color.b += flare3GTA*1.0f*flaremultB;	

					//flare new
vec2 flare3FLARE1scale = vec2(20.0f*flarescale, 20.0f*flarescale);
			  float flare3FLARE1pow = 0.5f;
			  float flare3FLARE1fill = 10.0f;
			  float flare3FLARE1offset = -1.2f; //-0.5
			vec2 flare3FLARE1pos = vec2(  ((1.0 - lPos.x)*(flare3FLARE1offset + 1.0) - (flare3FLARE1offset*0.5))  *aspectRatio*flare3FLARE1scale.x,  ((1.0 - lPos.y)*(flare3FLARE1offset + 1.0) - (flare3FLARE1offset*0.5))  *flare3FLARE1scale.y);
			
			
			float flare3FLARE1 = distance(flare3FLARE1pos, vec2(texcoord.s*aspectRatio*flare3FLARE1scale.x, texcoord.t*flare3FLARE1scale.y));
				  flare3FLARE1 = 0.5 - flare3FLARE1;
				  flare3FLARE1 = clamp(flare3FLARE1*flare3FLARE1fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3FLARE1 = sin(flare3FLARE1*1.57075);
				  flare3FLARE1 *= sunmask;
				  flare3FLARE1 = pow(flare3FLARE1, 1.1f);
				  
				  flare3FLARE1 *= flare3FLARE1pow;			
				  
				  
				 				  
				  
				  	color.r += flare3FLARE1*0.0f*flaremultR;
					color.g += flare3FLARE1*1.0f*flaremultG;
					color.b += flare3FLARE1*0.3f*flaremultB;
					
					//flarenew2
					vec2 flare3FLARE2scale = vec2(26.0f*flarescale, 26.0f*flarescale);
			  float flare3FLARE2pow = 0.5f;
			  float flare3FLARE2fill = 10.0f;
			  float flare3FLARE2offset = -1.25f; //-0.5
			vec2 flare3FLARE2pos = vec2(  ((1.0 - lPos.x)*(flare3FLARE2offset + 1.0) - (flare3FLARE2offset*0.5))  *aspectRatio*flare3FLARE2scale.x,  ((1.0 - lPos.y)*(flare3FLARE2offset + 1.0) - (flare3FLARE2offset*0.5))  *flare3FLARE2scale.y);
			
			
			float flare3FLARE2 = distance(flare3FLARE2pos, vec2(texcoord.s*aspectRatio*flare3FLARE2scale.x, texcoord.t*flare3FLARE2scale.y));
				  flare3FLARE2 = 0.5 - flare3FLARE2;
				  flare3FLARE2 = clamp(flare3FLARE2*flare3FLARE2fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3FLARE2 = sin(flare3FLARE2*1.57075);
				  flare3FLARE2 *= sunmask;
				  flare3FLARE2 = pow(flare3FLARE2, 1.1f);
				  
				  flare3FLARE2 *= flare3FLARE2pow;			
				  
				  
				 				  
				  
				  	color.r += flare3FLARE2*0.0f*flaremultR;
					color.g += flare3FLARE2*1.0f*flaremultG;
					color.b += flare3FLARE2*0.3f*flaremultB;	
					
					
					
					
					
					
					
					
					//INGO 
					vec2 flare3INGOscale = vec2(0.2f*flarescale, 50.0f*flarescale);
			  float flare3INGOpow = 0.7f;
			  float flare3INGOfill = 10.0f;
			  float flare3INGOoffset = -2.0f;
			vec2 flare3INGOpos = vec2(  ((1.0 - lPos.x)*(flare3INGOoffset + 1.0) - (flare3INGOoffset*0.5))  *aspectRatio*flare3INGOscale.x,  ((1.0 - lPos.y)*(flare3INGOoffset + 1.0) - (flare3INGOoffset*0.5))  *flare3INGOscale.y);
			
			
			float flare3INGO  = distance(flare3INGOpos, vec2(texcoord.s*aspectRatio*flare3INGOscale.x, texcoord.t*flare3INGOscale.y));
				  flare3INGO  = 0.5 - flare3INGO;
				  flare3INGO  = clamp(flare3INGO*flare3INGOfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3INGO  = sin(flare3INGO*1.57075);
				  flare3INGO  *= sunmask;
				  flare3INGO  = pow(flare3INGO, 1.1f);
				  
				  flare3INGO  *= flare3INGOpow;			
				  
				  
				 				  
				  
				  	color.r += flare3INGO *0.0f*flaremultR;
					color.g += flare3INGO *0.3f*flaremultG;
					color.b += flare3INGO *1.0f*flaremultB;
					
					
					
					
					//ANTIROT
			  vec2 flareROTscale = vec2(2.6f*flarescale, 2.6f*flarescale);
			  float flareROTpow = 1.4f;
			  float flareROTfill = 10.0f;
			  float flareROToffset = -2.3f;
			vec2 flareROTpos = vec2(  ((1.0 - lPos.x)*(flareROToffset + 1.0) - (flareROToffset*0.5))  *aspectRatio*flareROTscale.x,  ((1.0 - lPos.y)*(flareROToffset + 1.0) - (flareROToffset*0.5))  *flareROTscale.y);
			
			
			float flareROT = distance(flareROTpos, vec2(texcoord.s*aspectRatio*flareROTscale.x, texcoord.t*flareROTscale.y));
				  flareROT = 0.5 - flareROT;
				  flareROT = clamp(flareROT*flareROTfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flareROT = sin(flareROT*1.57075);
				  
				  flareROT = pow(flareROT, 1.1f);
				  
				  flareROT *= flareROTpow;			
				  
				  
				  //subtract from blue flare
				  vec2 flareROTSUBscale = vec2(1.7f*flarescale, 1.7f*flarescale);
				  float flareROTSUBpow = 2.7f;
				  float flareROTSUBfill = 1.4f;
				  float flareROTSUBoffset = -2.18f;
				vec2 flareROTSUBpos = vec2(  ((1.0 - lPos.x)*(flareROTSUBoffset + 1.0) - (flareROTSUBoffset*0.5))  *aspectRatio*flareROTSUBscale.x,  ((1.0 - lPos.y)*(flareROTSUBoffset + 1.0) - (flareROTSUBoffset*0.5))  *flareROTSUBscale.y);
			
			
				float flareROTSUB = distance(flareROTSUBpos, vec2(texcoord.s*aspectRatio*flareROTSUBscale.x, texcoord.t*flareROTSUBscale.y));
					flareROTSUB = 0.5 - flareROTSUB;
					flareROTSUB = clamp(flareROTSUB*flareROTSUBfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
					flareROTSUB = sin(flareROTSUB*1.57075);
					flareROTSUB = pow(flareROTSUB, 0.9f);
				  
					flareROTSUB *= flareROTSUBpow;
				  
				flareROT = clamp(flareROT - flareROTSUB, 0.0, 10.0);
				flareROT *= sunmask;
				  
				  	color.r += flareROT*1.0f*flaremultR;
					color.g += flareROT*0.4f*flaremultG;
					color.b += flareROT*0.0f*flaremultB;	
					
					
					
					
			vec2 flareROT2scale = vec2(3.2f*flarescale, 3.2f*flarescale);
			  float flareROT2pow = 1.4f;
			  float flareROT2fill = 10.0f;
			  float flareROT2offset = -0.7f;
			vec2 flareROT2pos = vec2(  ((1.0 - lPos.x)*(flareROT2offset + 1.0) - (flareROT2offset*0.5))  *aspectRatio*flareROT2scale.x,  ((1.0 - lPos.y)*(flareROT2offset + 1.0) - (flareROT2offset*0.5))  *flareROT2scale.y);
			
			
			float flareROT2 = distance(flareROT2pos, vec2(texcoord.s*aspectRatio*flareROT2scale.x, texcoord.t*flareROT2scale.y));
				  flareROT2 = 0.5 - flareROT2;
				  flareROT2 = clamp(flareROT2*flareROT2fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flareROT2 = sin(flareROT2*1.57075);
				  
				  flareROT2 = pow(flareROT2, 1.1f);
				  
				  flareROT2 *= flareROT2pow;			
				  
				  
				  //subtract from blue flare
				  vec2 flareROT2SUBscale = vec2(2.1f*flarescale, 2.1f*flarescale);
				  float flareROT2SUBpow = 2.7f;
				  float flareROT2SUBfill = 1.4f;
				  float flareROT2SUBoffset = -0.8f;
				vec2 flareROT2SUBpos = vec2(  ((1.0 - lPos.x)*(flareROT2SUBoffset + 1.0) - (flareROT2SUBoffset*0.5))  *aspectRatio*flareROT2SUBscale.x,  ((1.0 - lPos.y)*(flareROT2SUBoffset + 1.0) - (flareROT2SUBoffset*0.5))  *flareROT2SUBscale.y);
			
			
				float flareROT2SUB = distance(flareROT2SUBpos, vec2(texcoord.s*aspectRatio*flareROT2SUBscale.x, texcoord.t*flareROT2SUBscale.y));
					flareROT2SUB = 0.5 - flareROT2SUB;
					flareROT2SUB = clamp(flareROT2SUB*flareROT2SUBfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
					flareROT2SUB = sin(flareROT2SUB*1.57075);
					flareROT2SUB = pow(flareROT2SUB, 0.9f);
				  
					flareROT2SUB *= flareROT2SUBpow;
				  
				flareROT2 = clamp(flareROT2 - flareROT2SUB, 0.0, 10.0);
				flareROT2 *= sunmask;
				  
				  	color.r += flareROT2*1.0f*flaremultR;
					color.g += flareROT2*0.0f*flaremultG;
					color.b += flareROT2*0.3f*flaremultB;			
					
					
					
					
					
					
					
					
			//Far blue flare MAIN 2
			  vec2 flare3Cscale = vec2(1.2f*flarescale, 1.2f*flarescale);
			  float flare3Cpow = 1.4f;
			  float flare3Cfill = 10.0f;
			  float flare3Coffset = -0.2f;
			vec2 flare3Cpos = vec2(  ((1.0 - lPos.x)*(flare3Coffset + 1.0) - (flare3Coffset*0.5))  *aspectRatio*flare3Cscale.x,  ((1.0 - lPos.y)*(flare3Coffset + 1.0) - (flare3Coffset*0.5))  *flare3Cscale.y);
			
			
			float flare3C = distance(flare3Cpos, vec2(texcoord.s*aspectRatio*flare3Cscale.x, texcoord.t*flare3Cscale.y));
				  flare3C = 0.5 - flare3C;
				  flare3C = clamp(flare3C*flare3Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3C = sin(flare3C*1.57075);
				  
				  flare3C = pow(flare3C, 1.1f);
				  
				  flare3C *= flare3Cpow;			
				  
				  
				  //subtract from blue flare
				  vec2 flare3Dscale = vec2(0.8f*flarescale, 0.8f*flarescale);
				  float flare3Dpow = 2.7f;
				  float flare3Dfill = 1.4f;
				  float flare3Doffset = -0.27f;
				vec2 flare3Dpos = vec2(  ((1.0 - lPos.x)*(flare3Doffset + 1.0) - (flare3Doffset*0.5))  *aspectRatio*flare3Dscale.x,  ((1.0 - lPos.y)*(flare3Doffset + 1.0) - (flare3Doffset*0.5))  *flare3Dscale.y);
			
			
				float flare3D = distance(flare3Dpos, vec2(texcoord.s*aspectRatio*flare3Dscale.x, texcoord.t*flare3Dscale.y));
					flare3D = 0.5 - flare3D;
					flare3D = clamp(flare3D*flare3Dfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
					flare3D = sin(flare3D*1.57075);
					flare3D = pow(flare3D, 0.9f);
				  
					flare3D *= flare3Dpow;
				  
				flare3C = clamp(flare3C - flare3D, 0.0, 10.0);
				flare3C *= sunmask;
				  
				  	color.r += flare3C*0.4f*flaremultR;
					color.g += flare3C*0.7f*flaremultG;
					color.b += flare3C*1.0f*flaremultB;							
					
					
					
					
					
					
					
					
					
		
			
					
			//wtflol
			  vec2 flare5scale = vec2(1.15f*flarescale , 1.15f*flarescale );
			  float flare5pow = 13.4f;
			  float flare5fill = 1.0f;
			  float flare5offset = -2.0f;
			vec2 flare5pos = vec2(  ((1.0 - lPos.x)*(flare5offset + 1.0) - (flare5offset*0.5))  *aspectRatio*flare5scale.x,  ((1.0 - lPos.y)*(flare5offset + 1.0) - (flare5offset*0.5))  *flare5scale.y);
			
			
			float flare5 = distance(flare5pos, vec2(texcoord.s*aspectRatio*flare5scale.x, texcoord.t*flare5scale.y));
				  flare5 = 0.5 - flare5;
				  flare5 = clamp(flare5*flare5fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare5 *= sunmask;
				  flare5 = pow(flare5, 1.9f);
				  
				  flare5 *= flare5pow;
				  
				  	color.r += flare5*0.9f*flaremultR; //0.9
					color.g += flare5*0.4f*flaremultG;//0.4
					color.b += flare5*0.3f*flaremultB;	//	0.3				
				
					
	
					
			
			}
}

#endif

#ifdef CEL_SHADING
	color.rgb *= (getCellShaderFactor(texcoord.st));
#endif



#ifdef HDR


#endif;

color = color * BRIGHTMULT;

#ifdef CROSSPROCESS
	//pre-gain
	color = color * (BRIGHTMULT + 0.0f) + 0.03f;
	
	//compensate for low-light artifacts
	color = color+0.029f;
 
	//calculate double curve
	float dbr = -color.r + 1.4f;
	float dbg = -color.g + 1.4f;
	float dbb = -color.b + 1.4f;
	
	//fade between simple gamma up curve and double curve
	float pr = mix(dbr, 0.55f, 0.7f);
	float pg = mix(dbg, 0.55f, 0.7f);
	float pb = mix(dbb, 0.55f, 0.7f);
	
	color.r = pow((color.r * 0.95f - 0.005f), pr);
	color.g = pow((color.g * 0.95f - 0.002f), pg);
	color.b = pow((color.b * 0.91f + 0.000f), pb);
#endif

	//Color boosting
	color.r = (color.r)*(COLOR_BOOST + 1.0f) + (color.g + color.b)*(-COLOR_BOOST);
	color.g = (color.g)*(COLOR_BOOST + 1.0f) + (color.r + color.b)*(-COLOR_BOOST);
	color.b = (color.b)*(COLOR_BOOST + 1.0f) + (color.r + color.g)*(-COLOR_BOOST);
	
	//color.r = mix(((color.r)*(COLOR_BOOST + 1.0) + (hld.g + hld.b)*(-COLOR_BOOST)), hld.r, (max(((1-rgb)*2 - 1), 0.0)));
	//color.g = mix(((color.g)*(COLOR_BOOST + 1.0) + (hld.r + hld.b)*(-COLOR_BOOST)), hld.g, (max(((1-rgb)*2 - 1), 0.0)));
	//color.b = mix(((color.b)*(COLOR_BOOST + 1.0) + (hld.r + hld.g)*(-COLOR_BOOST)), hld.b, (max(((1-rgb)*2 - 1), 0.0)));

#ifdef HIGHDESATURATE


	//average
	float rgb = max(color.r, max(color.g, color.b))/2 + min(color.r, min(color.g, color.b))/2;

	//adjust black and white image to be brighter
	float bw = pow(rgb, 0.7f);

	//mix between per-channel analysis and average analysis
	float rgbr = mix(rgb, color.r, 0.7f);
	float rgbg = mix(rgb, color.g, 0.7f);
	float rgbb = mix(rgb, color.b, 0.7f);

	//calculate crossfade based on lum
	float mixfactorr = max(0.0f, (rgbr*4.0f - 3.0f));
	float mixfactorg = max(0.0f, (rgbg*4.0f - 3.0f));
	float mixfactorb = max(0.0f, (rgbb*4.0f - 3.0f));

	//crossfade between saturated and desaturated image
	float mixr = mix(color.r, bw, mixfactorr);
	float mixg = mix(color.g, bw, mixfactorg);
	float mixb = mix(color.b, bw, mixfactorb);

	//adjust level of desaturation
	color.r = clamp((mix(mixr, color.r, 1.0)), 0.0f, 10.0f);
	color.g = clamp((mix(mixg, color.g, 1.0)), 0.0f, 10.0f);
	color.b = clamp((mix(mixb, color.b, 1.0)), 0.0f, 10.0f);
	
	//desaturate blue channel
	//color.b = color.b*0.8f + ((color.r + color.g)/2.0f)*0.2f;
	

	//hold color values for color boost
	//vec4 hld = color;

	
	

	

	
	//color = color * BRIGHTMULT;


	
#endif

	//undo artifact compensation
	color = max(((color*1.10f) - 0.06f), 0.0f);


	

	
//color *= 1.1f;

#ifdef VINTAGE

	color.r = clamp(color.r, 0.04, 1.0);

	color.b = clamp(color.b, 0.06, 0.89);
	
	//color.r = pow(color.r, GAMMA);
	//color.g = pow(color.g, GAMMA);
	//color.b = pow(color.b, GAMMA);
#endif



/*
float exposureb = 3.0f;

color.rgb = (1.0f - exp( -color.rgb * exposureb ));

color.rgb *= 1.18;
color.rgb -= 0.05;
*/
/*
float aor = texture2D(gaux1,texcoord.xy).a;
color = vec4(aor,aor,aor,1.0);
*/
	gl_FragColor = vec4(color.rgb,1.0);
	
// End of Main. -----------------
}
